/*
 * Decompiled with CFR 0.152.
 */
package com.ytgram.core;

import com.ytgram.core.YTDLPManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public class DownloadManager {
    private volatile boolean isDownloading = false;

    public void downloadQueue(List<String> list, String string, String string2, ProgressCallback progressCallback) {
        if (this.isDownloading) {
            progressCallback.onError("Download already in progress");
            return;
        }
        new Thread(() -> {
            this.isDownloading = true;
            try {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    String string3 = (String)list.get(i);
                    int n2 = i + 1;
                    SwingUtilities.invokeLater(() -> progressCallback.onProgress(0, String.format("Downloading %d/%d: %s", n2, n, string3)));
                    boolean bl = this.downloadSingle(string3, string, string2, progressCallback);
                    if (bl) continue;
                    SwingUtilities.invokeLater(() -> progressCallback.onError(String.format("Failed to download: %s", string3)));
                }
                SwingUtilities.invokeLater(() -> {
                    progressCallback.onProgress(100, "All downloads complete!");
                    progressCallback.onComplete();
                });
            }
            catch (Exception exception) {
                SwingUtilities.invokeLater(() -> progressCallback.onError("Download error: " + exception.getMessage()));
            }
            finally {
                this.isDownloading = false;
            }
        }).start();
    }

    private boolean downloadSingle(String string, String string2, String string3, ProgressCallback progressCallback) {
        try {
            String string4;
            String[] stringArray = YTDLPManager.buildCommand(string, string2, string3);
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            processBuilder.redirectErrorStream(true);
            String string5 = System.getProperty("user.home");
            String string6 = processBuilder.environment().get("PATH");
            String string7 = string5 + "/.local/bin";
            if (string6 != null && !string6.contains(string7)) {
                processBuilder.environment().put("PATH", string7 + File.pathSeparator + string6);
            } else if (string6 == null) {
                processBuilder.environment().put("PATH", string7);
            }
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            Pattern pattern = Pattern.compile("\\[download\\]\\s+(\\d+\\.?\\d*)%");
            while ((string4 = bufferedReader.readLine()) != null) {
                String string8 = string4;
                Matcher matcher = pattern.matcher(string4);
                if (matcher.find()) {
                    try {
                        double d = Double.parseDouble(matcher.group(1));
                        SwingUtilities.invokeLater(() -> progressCallback.onProgress((int)d, string8));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                SwingUtilities.invokeLater(() -> progressCallback.onProgress(0, string8));
            }
            int n = process.waitFor();
            return n == 0;
        }
        catch (Exception exception) {
            SwingUtilities.invokeLater(() -> progressCallback.onError("Error executing yt-dlp: " + exception.getMessage()));
            return false;
        }
    }

    public boolean isDownloading() {
        return this.isDownloading;
    }

    public static interface ProgressCallback {
        public void onProgress(int var1, String var2);

        public void onComplete();

        public void onError(String var1);
    }
}

