/*
 * Decompiled with CFR 0.152.
 */
package com.ytgram.ui;

import com.ytgram.config.Settings;
import com.ytgram.core.ClipboardMonitor;
import com.ytgram.core.DownloadManager;
import com.ytgram.core.YTDLPManager;
import com.ytgram.ui.OS2Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class MainWindow
extends JFrame {
    private Settings settings = new Settings();
    private DownloadManager downloadManager = new DownloadManager();
    private ClipboardMonitor clipboardMonitor;
    private JTextField urlField;
    private JCheckBox clipboardCheckbox;
    private DefaultListModel<String> queueModel;
    private JList<String> queueList;
    private ButtonGroup formatGroup;
    private JRadioButton mp3Radio;
    private JRadioButton aacRadio;
    private JRadioButton oggRadio;
    private JRadioButton video360Radio;
    private JRadioButton videoHDRadio;
    private JRadioButton video4KRadio;
    private JTextField directoryField;
    private JProgressBar progressBar;
    private JTextArea statusArea;
    private JButton startButton;

    public MainWindow() {
        this.initUI();
        this.loadSettings();
        this.checkYTDLP();
    }

    private void initUI() {
        this.setTitle("ytgram - YouTube Downloader");
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout(10, 10));
        this.getContentPane().setBackground(OS2Theme.OS2_GRAY);
        ((JPanel)this.getContentPane()).setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)this.createTopPanel(), "North");
        this.add((Component)this.createCenterPanel(), "Center");
        this.add((Component)this.createRightPanel(), "East");
        this.add((Component)this.createBottomPanel(), "South");
        this.setSize(900, 600);
        this.setLocationRelativeTo(null);
    }

    private JPanel createTopPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBackground(OS2Theme.OS2_GRAY);
        jPanel.setBorder(OS2Theme.createPanelBorder());
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.setBackground(OS2Theme.OS2_GRAY);
        JLabel jLabel = new JLabel("URL:");
        this.urlField = new JTextField();
        JButton jButton = new JButton("Add to Queue");
        jButton.addActionListener(actionEvent -> this.addToQueue());
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)this.urlField, "Center");
        jPanel2.add((Component)jButton, "East");
        this.clipboardCheckbox = new JCheckBox("Auto-grab from clipboard");
        this.clipboardCheckbox.setBackground(OS2Theme.OS2_GRAY);
        this.clipboardCheckbox.addActionListener(actionEvent -> this.toggleClipboardMonitor());
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)this.clipboardCheckbox, "South");
        return jPanel;
    }

    private JPanel createCenterPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBackground(OS2Theme.OS2_GRAY);
        jPanel.setBorder(OS2Theme.createPanelBorder());
        JLabel jLabel = new JLabel("Download Queue:");
        jLabel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.queueModel = new DefaultListModel();
        this.queueList = new JList<String>(this.queueModel);
        this.queueList.setBackground(OS2Theme.OS2_WHITE);
        this.queueList.setForeground(OS2Theme.OS2_BLACK);
        this.queueList.setFont(new Font("Dialog", 0, 12));
        JScrollPane jScrollPane = new JScrollPane(this.queueList);
        jScrollPane.setBorder(OS2Theme.createLoweredBorder());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 5, 5));
        jPanel2.setBackground(OS2Theme.OS2_GRAY);
        JButton jButton = new JButton("Remove Selected");
        jButton.addActionListener(actionEvent -> this.removeSelected());
        JButton jButton2 = new JButton("Clear Queue");
        jButton2.addActionListener(actionEvent -> this.clearQueue());
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JPanel createRightPanel() {
        JRadioButton[] jRadioButtonArray;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(OS2Theme.OS2_GRAY);
        jPanel.setBorder(OS2Theme.createPanelBorder());
        JLabel jLabel = new JLabel("Format:");
        jLabel.setAlignmentX(0.0f);
        jLabel.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.formatGroup = new ButtonGroup();
        this.mp3Radio = new JRadioButton("MP3 (audio + metadata)");
        this.aacRadio = new JRadioButton("AAC (audio + metadata)");
        this.oggRadio = new JRadioButton("OGG (audio + metadata)");
        this.video360Radio = new JRadioButton("360p Video");
        this.videoHDRadio = new JRadioButton("HD Video (1080p)");
        this.video4KRadio = new JRadioButton("4K Video (2160p)");
        for (JRadioButton jRadioButton : jRadioButtonArray = new JRadioButton[]{this.mp3Radio, this.aacRadio, this.oggRadio, this.video360Radio, this.videoHDRadio, this.video4KRadio}) {
            jRadioButton.setBackground(OS2Theme.OS2_GRAY);
            jRadioButton.setAlignmentX(0.0f);
            this.formatGroup.add(jRadioButton);
            jPanel.add(jRadioButton);
            jPanel.add(Box.createVerticalStrut(5));
        }
        this.mp3Radio.setSelected(true);
        jPanel.add(jLabel);
        for (JRadioButton jRadioButton : jRadioButtonArray) {
            jPanel.add(jRadioButton);
            jPanel.add(Box.createVerticalStrut(5));
        }
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    private JPanel createBottomPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBackground(OS2Theme.OS2_GRAY);
        jPanel.setBorder(OS2Theme.createPanelBorder());
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.setBackground(OS2Theme.OS2_GRAY);
        JLabel jLabel = new JLabel("Download to:");
        this.directoryField = new JTextField();
        JButton jButton = new JButton("Browse");
        jButton.addActionListener(actionEvent -> this.browseDirectory());
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)this.directoryField, "Center");
        jPanel2.add((Component)jButton, "East");
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel3.setBackground(OS2Theme.OS2_GRAY);
        JButton jButton2 = new JButton("Install/Update yt-dlp");
        jButton2.addActionListener(actionEvent -> this.installOrUpdateYTDLP());
        this.startButton = new JButton("Start Downloads");
        this.startButton.addActionListener(actionEvent -> this.startDownloads());
        jPanel3.add(jButton2);
        jPanel3.add(this.startButton);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setBorder(OS2Theme.createLoweredBorder());
        this.statusArea = new JTextArea(5, 40);
        this.statusArea.setEditable(false);
        this.statusArea.setBackground(OS2Theme.OS2_WHITE);
        this.statusArea.setForeground(OS2Theme.OS2_BLACK);
        this.statusArea.setFont(new Font("Monospaced", 0, 11));
        JScrollPane jScrollPane = new JScrollPane(this.statusArea);
        jScrollPane.setBorder(OS2Theme.createLoweredBorder());
        JPanel jPanel4 = new JPanel(new BorderLayout(5, 5));
        jPanel4.setBackground(OS2Theme.OS2_GRAY);
        jPanel4.add((Component)jPanel2, "North");
        jPanel4.add((Component)jPanel3, "Center");
        jPanel4.add((Component)this.progressBar, "South");
        jPanel.add((Component)jPanel4, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void addToQueue() {
        String string = this.urlField.getText().trim();
        if (!string.isEmpty()) {
            this.queueModel.addElement(string);
            this.urlField.setText("");
            this.appendStatus("Added to queue: " + string);
        }
    }

    private void removeSelected() {
        int[] nArray = this.queueList.getSelectedIndices();
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.queueModel.remove(nArray[i]);
        }
    }

    private void clearQueue() {
        this.queueModel.clear();
        this.appendStatus("Queue cleared");
    }

    private void browseDirectory() {
        JFileChooser jFileChooser = new JFileChooser(this.directoryField.getText());
        jFileChooser.setFileSelectionMode(1);
        if (jFileChooser.showOpenDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            this.directoryField.setText(file.getAbsolutePath());
            this.settings.setDownloadDirectory(file.getAbsolutePath());
        }
    }

    private void toggleClipboardMonitor() {
        if (this.clipboardCheckbox.isSelected()) {
            this.clipboardMonitor = new ClipboardMonitor(string -> SwingUtilities.invokeLater(() -> {
                this.urlField.setText(string);
                this.appendStatus("URL detected from clipboard: " + string);
            }));
            this.clipboardMonitor.start();
            this.settings.setClipboardEnabled(true);
            this.appendStatus("Clipboard monitoring enabled");
        } else {
            if (this.clipboardMonitor != null) {
                this.clipboardMonitor.stopMonitoring();
                this.clipboardMonitor = null;
            }
            this.settings.setClipboardEnabled(false);
            this.appendStatus("Clipboard monitoring disabled");
        }
    }

    private void installOrUpdateYTDLP() {
        if (YTDLPManager.checkYTDLPInstalled()) {
            YTDLPManager.updateYTDLP();
            this.appendStatus("Updating yt-dlp...");
        } else {
            YTDLPManager.installYTDLP();
            this.appendStatus("Installing yt-dlp...");
        }
    }

    private void startDownloads() {
        if (this.queueModel.isEmpty()) {
            this.appendStatus("Queue is empty!");
            return;
        }
        if (!YTDLPManager.checkYTDLPInstalled()) {
            JOptionPane.showMessageDialog(this, "yt-dlp is not installed. Please install it first using the Install/Update button.", "Error", 0);
            return;
        }
        String string = this.getSelectedFormat();
        String string2 = this.directoryField.getText();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.queueModel.size(); ++i) {
            arrayList.add(this.queueModel.getElementAt(i));
        }
        this.startButton.setEnabled(false);
        this.progressBar.setValue(0);
        this.statusArea.setText("");
        this.downloadManager.downloadQueue(arrayList, string, string2, new DownloadManager.ProgressCallback(){

            @Override
            public void onProgress(int n, String string) {
                MainWindow.this.progressBar.setValue(n);
                MainWindow.this.appendStatus(string);
            }

            @Override
            public void onComplete() {
                MainWindow.this.startButton.setEnabled(true);
                MainWindow.this.queueModel.clear();
            }

            @Override
            public void onError(String string) {
                MainWindow.this.appendStatus("ERROR: " + string);
                MainWindow.this.startButton.setEnabled(true);
            }
        });
    }

    private String getSelectedFormat() {
        if (this.mp3Radio.isSelected()) {
            return "mp3";
        }
        if (this.aacRadio.isSelected()) {
            return "aac";
        }
        if (this.oggRadio.isSelected()) {
            return "ogg";
        }
        if (this.video360Radio.isSelected()) {
            return "360p";
        }
        if (this.videoHDRadio.isSelected()) {
            return "hd";
        }
        if (this.video4KRadio.isSelected()) {
            return "4k";
        }
        return "mp3";
    }

    private void loadSettings() {
        this.directoryField.setText(this.settings.getDownloadDirectory());
        this.clipboardCheckbox.setSelected(this.settings.isClipboardEnabled());
        if (this.settings.isClipboardEnabled()) {
            this.toggleClipboardMonitor();
        }
        String string = this.settings.getDefaultFormat();
        switch (string.toLowerCase()) {
            case "mp3": {
                this.mp3Radio.setSelected(true);
                break;
            }
            case "aac": {
                this.aacRadio.setSelected(true);
                break;
            }
            case "ogg": {
                this.oggRadio.setSelected(true);
                break;
            }
            case "360p": {
                this.video360Radio.setSelected(true);
                break;
            }
            case "hd": {
                this.videoHDRadio.setSelected(true);
                break;
            }
            case "4k": {
                this.video4KRadio.setSelected(true);
            }
        }
    }

    private void checkYTDLP() {
        if (!YTDLPManager.checkYTDLPInstalled()) {
            this.appendStatus("WARNING: yt-dlp is not installed. Click 'Install/Update yt-dlp' to install.");
        } else {
            this.appendStatus("yt-dlp is installed and ready.");
        }
    }

    private void appendStatus(String string) {
        this.statusArea.append(string + "\n");
        this.statusArea.setCaretPosition(this.statusArea.getDocument().getLength());
    }
}

